﻿using Sunny.UI;
using ZSMusic.Winform.Properties;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ZSMusic.Model;
using ZSMusic.BLLEX;

namespace  ZSMusic.Winform
{
    public partial class FrmMultiple : UIForm
    {
        public List<Music> List { get; set; }
        public FrmMain MainForm { get; set; }
        public FrmMultiple(List<Music> list)
        {
            List = list;
            InitializeComponent();
            foreach (Music item in List)
            {
                lstMusic.Items.Add(item);
            }
            this.Text = string.Format("共有{0}首歌", lstMusic.Count);
        }

        private void lstMusic_ItemsCountChange(object sender, EventArgs e)
        {
                this.Text = string.Format("共有{0}首歌", lstMusic.Count);
        }

        private void lstMusic_ItemDoubleClick(object sender, EventArgs e)
        {
                lstMusic.Items.Remove(lstMusic.SelectedItem);
        }

        private void btnLove_Click(object sender, EventArgs e)
        {
            foreach (Music item in lstMusic.Items)
            {
                MainForm.lstLove.Items.Add(item);
            }
            
            this.ShowSuccessTip("收藏成功");
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            foreach (Music item in lstMusic.Items)
            {
                MainForm.playList.Items.Add(item);
            }
            this.ShowSuccessTip("添加成功");
        }

        private void btnDown_Click(object sender, EventArgs e)
        {
            List<Music> list = new List<Music>();
            foreach (Music item in lstMusic.Items)
            {
                list.Add(item);
            }
            MainForm.Download(list);
        }

        private void bgwDown_DoWork(object sender, DoWorkEventArgs e)
        {
            //btnDown.Enabled = false;
            //int count = 0;
            //psbDown.Value = 0;
            //for (int i = 0; i < lstMusic.Count; i++)
            //{
            //    try
            //    {
            //        MusicHelper h = new MusicHelper(lstMusic.Items[i] as Music);
            //        this.Text = "正在获取歌曲信息: " + h.MusicModel;
            //        if (!h.GetData())
            //        {
            //            h.MusicModel = MusicHelper.ReSearch(h.MusicModel, UserSettings.Current.重新查找精确度);
            //        }
            //        this.Text = "正在下载: " + h.MusicModel;
            //        h.Download();
            //        count++;
            //    }
            //    catch (Exception ex)
            //    {
            //        Console.WriteLine(ex.Message);
            //    }
            //    finally { psbDown.Value++; }
            //}
            //this.Text = "下载已完成";
            //MusicHelper.MainForm.notify.ShowBalloonTip(5000,"下载完成",string.Format("一共下载了{0}首歌",count),ToolTipIcon.Info);
            //btnDown.Enabled = true;
        }

    }
}
